document.getElementById('phone').addEventListener('input', function (e) {
    var x = e.target.value.replace(/\D/g, '').match(/(\d{0,3})(\d{0,3})(\d{0,4})/);
    e.target.value = !x[2] ? x[1] : '(' + x[1] + ') ' + x[2] + (x[3] ? '-' + x[3] : '');
    validatePhoneNumber();
});

document.getElementById('phoneForm').addEventListener('submit', function (e) {
    if (!validatePhoneNumber()) {
        e.preventDefault();
        document.getElementById('phone').classList.add('zoom-out');
        setTimeout(function () {
            document.getElementById('phone').classList.remove('zoom-out');
        }, 100);
    }
});

function validatePhoneNumber() {
    var phoneInput = document.getElementById('phone').value;
    var phonePattern = /^\(\d{3}\) \d{3}-\d{4}$/;
    var isValid = phonePattern.test(phoneInput);
    var hasTenDigits = phoneInput.replace(/\D/g, '').length === 10;
    var isValidNumber = isValid && hasTenDigits;
    document.getElementById('phoneError').style.display = isValidNumber ? 'none' : 'block';
    return isValidNumber;
}